from __future__ import with_statement

from string import split
from string import join

from win32com.client import constants

#----------------------------------------
# Paths
#----------------------------------------
def stripPath(fullPath, rootPath):
	"""Strips the root path from a full path, and removes
	the extension if removeExtension is True."""
	
	#safety check
	if rootPath != fullPath[:len(rootPath)]:
		Application.LogMessage(fullPath)
		Application.LogMessage(rootPath)
		raise Exception('The full path is not in the root path!')
		
	if fullPath[-4:] != '.xsi':
		raise Exception('Expected the extension ".xsi" in the filename, but found "' + fullPath[-4:] + '"')
		
	Application.LogMessage(rootPath)
	relativePath = fullPath[len(rootPath):][:-4]
	
	if relativePath[0] == '\\': #remove beginning slash
		relativePath = relativePath[1:]
	
	return relativePath 

#----------------------------------------
# ExportProperties
#----------------------------------------
def CodeSpot_Export_Properties_Define(ioContext):
	pSet = ioContext.Source
	pSet.AddParameter3('LevelFile', constants.siString)
	pSet.AddParameter3('XNAProjectPath', constants.siString)
	
def CodeSpot_Export_Properties_DefineLayout(ioContext):
	layout = ioContext.Source
	layout.Clear()
	layout.AddItem('LevelFile', 'Level File', constants.siControlFilePath)
	layout.AddItem('XNAProjectPath', 'XNA Content Project Path', constants.siControlFolder)

#----------------------------------------
# AddExportProperties
#----------------------------------------
def addExportProperties():
	root = Application.ActiveProject.ActiveScene.Root
	root.AddProperty('CodeSpot_Export_Properties')

def CodeSpot_Add_Export_Properties_Init(ioContext):
	return True	

def CodeSpot_Add_Export_Properties_Execute():
	addExportProperties()
	
	return True

#----------------------------------------
# ExportLevel
#----------------------------------------

def quote(str):
	return '"' + str + '"'

def vectorToString(vec):
	return str(vec[0]) + ' ' + str(vec[1]) + ' ' + str(vec[2])

def getPosition(obj):
	return [obj.posx.Value, obj.posy.Value, obj.posz.Value]

def exportModelData(xnaProjectPath, file, model):
	positionStr = vectorToString(getPosition(model))
	
	pSet = model.Properties('XNA_Asset')
	
	if pSet == None:
		raise 'The selected model is not an XNA asset. Did you create the model from the XNA toolabr?'
	
	path = pSet.Parameters('AssetPath').Value
	relativePath = stripPath(path, xnaProjectPath)
	
	
	
	xml = '\t\t<Item>\n\t\t\t<Position>' + positionStr +'</Position>\n\t\t\t<ModelAsset>' + relativePath + '</ModelAsset>\n' + '\t\t</Item>\n'
	file.write(xml)

def exportLevel():
	root = Application.ActiveProject.ActiveScene.Root
	pSet = root.Properties('CodeSpot_Export_Properties')
	fileName = pSet.Parameters('LevelFile').Value
	xnaProjectPath = pSet.Parameters('XNAProjectPath').Value
	
	if fileName == '':
		raise Exception('You did not specify an export file')
	
	with open(fileName, 'w') as file:
		file.write('<?xml version="1.0" encoding="utf-8"?>\n')
		file.write('<XnaContent>\n')
		file.write('<Asset Type="System.Collections.Generic.List[SOFTIMAGE_XNAViewer.RenderShape]">\n')

		
		for obj in Application.Selection:
			if obj.Type == '#model':
				exportModelData(xnaProjectPath, file, obj)
		
		file.write('</Asset>\n')
		file.write('</XnaContent>\n')
	
def CodeSpot_Export_Level_Execute():
	exportLevel()

	return True
	
	
#----------------------------------------
# Register Plug-in
#----------------------------------------
def XSILoadPlugin( in_reg ):
	sCommandFile = in_reg.FileName
	in_reg.Author = 'Herman Tulleken (herman.tulleken@gmail.com)'
	in_reg.Name = 'XNA Level Editor Example'
	in_reg.Major = 1
	in_reg.Minor = 0	
	in_reg.RegisterCommand('CodeSpot_Add_Export_Properties')
	in_reg.RegisterCommand('CodeSpot_Export_Level')
	
	in_reg.RegisterProperty('CodeSpot_Export_Properties')
	Application.LogMessage('XNA Level Editor Example Loaded')
	return True	
	
Application.LogMessage('*****')